
function [dm,e] = am_test(fc,dfc,bplot)
% AM_TEST Tests the effect of carrier frequency on a speech signal
%   [dm,e] = am_test(fc,dfc)
%
%   fc:    carrier frequency in Hertz
%   dfc:   delta carrier frequency to simulate lack of frequency coherence
%   bplot: plotting flag (1:plot, 0:don't plot)
%   dm:    demodulated signal
%   e:     the error, original minus demodulated

% ------- am_test.m ----------------------------------------
% Marios Athineos, marios@ee.columbia.edu
% http://www.ee.columbia.edu/~marios/
% Copyright (c) 2003 by Columbia University.
% All rights reserved.
% ----------------------------------------------------------

% Default values
if nargin < 2; dfc   = 0; end % No coherence error
if nargin < 3; bplot = 1; end % Plot by default

% Load the modulating signal (speech) and its sampling frequency
[m,fs] = wavread('sm1_cln_32k.wav');
% Keep only a small part of it to speed up calculations
m = m(1:42000);

% Modulate ...
u  = mymod(m,fc,fs);
% ... and demodulate
dm = mydemod(u,fc+dfc,fs);

if bplot
    % Make the frequency index for plotting
    t = linspace(0,length(m)/fs,length(m));
    f = linspace(-fs/2,fs/2,length(m));
    am_plot(t,m,u,dm);
    am_plot(t,am_spectrum(m),am_spectrum(u),am_spectrum(dm));
end

% How does the demodulated one sound like ?
soundsc(dm,fs);

% And the error is
e = m-dm;